/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Copyright  2009 ParaType Ltd. All rights reserved.
 * 
 * Trademark:
 * PT Sans is a trademark of the ParaType Ltd.
 * 
 * Description:
 * PT Sans is a type family of universal use. It consists of 8 styles: regular and
 * bold weights with corresponding italics form a standard computer font family;
 * two narrow styles (regular and bold) are intended for documents that require
 * tight set; two caption styles (regular and bold) are for texts of small point
 * sizes. The design combines traditional conservative appearance with modern
 * trends of humanistic sans serif and characterized by enhanced legibility. These
 * features beside conventional use in business applications and printed stuff made
 * the fonts quite useable for direction and guide signs, schemes, screens of
 * information kiosks and other objects of urban visual communications.
 * 
 * The fonts next to standard Latin and Cyrillic character sets contain signs of
 * title languages of the national republics of Russian Federation and support the
 * most of the languages of neighboring countries. The fonts were developed and
 * released by ParaType in 2009 with financial support from Federal Agency of Print
 * and Mass Communications of Russian Federation. Design - Alexandra Korolkova with
 * assistance of Olga Umpeleva and supervision of Vladimir Yefimov.
 * 
 * Manufacturer:
 * ParaType Ltd
 * 
 * Designer:
 * A.Korolkova, O.Umpeleva, V.Yefimov
 * 
 * Vendor URL:
 * http://www.paratype.com
 */
Cufon.registerFont({"w":228,"face":{"font-family":"PT Sans Caption","font-weight":400,"font-variant":"small-caps","font-stretch":"normal","units-per-em":"360","panose-1":"2 11 6 3 2 2 3 2 2 4","ascent":"288","descent":"-72","x-height":"5","bbox":"-14 -313 385 83.5189","underline-thickness":"18","underline-position":"-18","unicode-range":"U+0020-U+2122"},"glyphs":{" ":{"w":104,"k":{"*":2,"-":3,"\u00ad":3,"\u2013":3,"\u2014":3,",":5,".":5,"\u2026":5,"T":11,"V":11,"W":7,"X":11,"Y":11,"\u00dd":11,"Z":8,"\"":24,"'":24,"\u2018":24,"\u2019":24,"\u201c":24,"\u201d":24,"A":12,"\u00c0":12,"\u00c1":12,"\u00c2":12,"\u00c3":12,"\u00c4":12,"\u00c5":12}},"!":{"d":"48,-252r36,0v0,65,2,132,-8,186r-21,0v-9,-55,-7,-122,-7,-186xm66,4v-14,0,-25,-9,-25,-22v0,-14,10,-23,25,-23v14,0,24,9,24,23v-1,12,-10,22,-24,22","w":119},"\"":{"d":"35,-252r33,0r-12,71r-21,0r0,-71xm82,-252r33,0r-12,71r-21,0r0,-71","w":135,"k":{" ":30,"\u00a0":30,"-":54,"\u00ad":54,"\u2013":54,"\u2014":54,",":44,".":44,"\u2026":44,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"c":36,"e":36,"g":36,"o":36,"q":36,"\u00e7":36,"\u00e8":36,"\u00e9":36,"\u00ea":36,"\u00eb":36,"\u00f0":36,"\u00f2":36,"\u00f3":36,"\u00f4":36,"\u00f5":36,"\u00f6":36,"\u00f8":36,"\u00c6":72,"A":44,"\u00c0":44,"\u00c1":44,"\u00c2":44,"\u00c3":44,"\u00c4":44,"\u00c5":44,"a":22,"m":22,"n":22,"p":22,"r":22,"s":22,"u":22,"\u00e6":22}},"#":{"d":"117,-80r-41,0r-15,59r-29,0r15,-59r-30,0r6,-25r31,0r12,-45r-30,0r6,-26r30,0r15,-55r29,0r-14,55r40,0r15,-55r29,0r-15,55r30,0r-7,26r-29,0r-12,45r28,0r-6,25r-29,0r-15,59r-29,0xm83,-105r41,0r11,-45r-40,0"},"$":{"d":"155,-132v64,22,51,137,-25,135r0,33r-28,0r0,-31v-27,0,-49,-5,-66,-13r11,-30v14,6,32,13,55,12r0,-90v-32,-13,-64,-29,-65,-73v0,-42,25,-62,65,-67r0,-32r28,0r0,32v24,0,41,4,56,11r-10,29v-13,-5,-27,-9,-46,-10r0,82xm122,-26v43,2,56,-60,16,-73v-5,-3,-10,-6,-16,-8r0,81xm110,-226v-34,-2,-50,37,-27,57v7,6,16,11,27,16r0,-73"},"%":{"d":"89,-134v-40,0,-62,-20,-62,-61v0,-41,22,-61,62,-61v40,0,62,21,62,61v0,40,-22,61,-62,61xm89,-233v-23,0,-31,12,-31,38v0,24,9,38,31,38v22,0,30,-13,30,-38v0,-26,-7,-38,-30,-38xm232,0v-40,0,-62,-21,-62,-61v0,-40,22,-61,62,-61v40,0,62,20,62,61v0,41,-22,61,-62,61xm232,-99v-23,0,-30,12,-30,38v0,24,9,38,30,38v22,0,31,-13,31,-38v0,-26,-8,-38,-31,-38xm253,-257r21,18r-206,244r-20,-18","w":307},"&":{"d":"224,-28v-43,47,-182,48,-179,-40v1,-48,35,-70,67,-89v-11,-14,-23,-31,-23,-53v0,-33,24,-47,59,-47v34,0,58,14,58,45v0,30,-24,48,-52,61v18,28,44,57,69,80v14,-13,23,-35,31,-55r26,14v-8,22,-23,43,-37,60v16,13,29,24,48,32r-21,25v-16,-8,-32,-20,-46,-33xm79,-69v0,57,98,53,124,20v-28,-25,-54,-58,-76,-87v-23,18,-48,32,-48,67xm149,-231v-40,-1,-25,46,-9,63v19,-12,32,-19,36,-38v0,-18,-9,-24,-27,-25","w":320},"'":{"d":"35,-252r33,0r-12,71r-21,0r0,-71","w":87,"k":{" ":30,"\u00a0":30,"-":54,"\u00ad":54,"\u2013":54,"\u2014":54,",":44,".":44,"\u2026":44,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"c":36,"e":36,"g":36,"o":36,"q":36,"\u00e7":36,"\u00e8":36,"\u00e9":36,"\u00ea":36,"\u00eb":36,"\u00f0":36,"\u00f2":36,"\u00f3":36,"\u00f4":36,"\u00f5":36,"\u00f6":36,"\u00f8":36,"\u00c6":72,"A":44,"\u00c0":44,"\u00c1":44,"\u00c2":44,"\u00c3":44,"\u00c4":44,"\u00c5":44,"a":22,"m":22,"n":22,"p":22,"r":22,"s":22,"u":22,"\u00e6":22}},"(":{"d":"112,-241v-70,64,-70,240,0,304r-22,16v-70,-54,-88,-211,-31,-296v9,-14,20,-27,32,-39","w":113,"k":{"-":2,"\u00ad":2,"\u2013":2,"\u2014":2}},")":{"d":"1,63v71,-64,69,-238,0,-303r22,-16v70,54,89,213,30,296v-9,14,-19,27,-31,39","w":112},"*":{"d":"52,-261v8,10,13,23,17,37v4,-14,10,-26,17,-37r19,11v-7,14,-17,25,-28,35v14,-3,28,-6,46,-5r0,22v-17,1,-30,-2,-43,-5v10,10,20,20,27,33r-20,11v-8,-11,-14,-25,-19,-39v-3,15,-8,28,-16,38r-21,-11v7,-13,17,-23,28,-32v-13,3,-26,6,-43,5r0,-22v17,-1,31,2,44,5v-11,-10,-21,-20,-28,-34","w":139,"k":{" ":2,"\u00a0":2,"-":57,"\u00ad":57,"\u2013":57,"\u2014":57,",":90,".":90,"\u2026":90,"\u00c6":8,"A":4,"\u00c0":4,"\u00c1":4,"\u00c2":4,"\u00c3":4,"\u00c4":4,"\u00c5":4}},"+":{"d":"15,-136r69,0r0,-69r31,0r0,69r69,0r0,30r-69,0r0,69r-31,0r0,-69r-69,0r0,-30","w":199},",":{"d":"42,-38v47,1,28,77,0,86v-5,3,-10,5,-15,6r-10,-17v14,-4,26,-19,27,-35v-14,4,-25,-5,-25,-19v0,-12,12,-21,23,-21","w":78,"k":{" ":11,"\u00a0":11,"*":9,"-":45,"\u00ad":45,"\u2013":45,"\u2014":45,"T":4,"V":4,"W":3,"Y":5,"\u00dd":5,"\"":50,"'":50,"\u2018":50,"\u2019":50,"\u201c":50,"\u201d":50,"\u00ae":6,"\u2122":6}},"-":{"d":"23,-120r96,0r0,31r-96,0r0,-31","w":141,"k":{" ":29,"\u00a0":29,"*":3,"-":4,"\u00ad":4,"\u2013":4,"\u2014":4,",":45,".":45,"\u2026":45,"T":5,"V":2,"X":3,"Y":3,"\u00dd":3,"\u00c6":3,"\"":44,"'":44,"\u2018":44,"\u2019":44,"\u201c":44,"\u201d":44,")":2,"]":2,"}":2}},".":{"d":"43,4v-14,0,-24,-9,-24,-22v0,-15,9,-23,24,-23v14,0,24,9,24,23v-1,12,-10,22,-24,22","w":85,"k":{" ":11,"\u00a0":11,"*":9,"-":45,"\u00ad":45,"\u2013":45,"\u2014":45,"T":4,"V":4,"W":3,"Y":5,"\u00dd":5,"\"":50,"'":50,"\u2018":50,"\u2019":50,"\u201c":50,"\u201d":50,"\u00ae":6,"\u2122":6}},"\/":{"d":"130,-256r26,12r-143,294r-27,-13","w":142},"0":{"d":"114,5v-70,0,-91,-57,-91,-131v0,-74,23,-131,91,-131v70,0,92,54,92,131v0,74,-25,131,-92,131xm114,-228v-46,0,-56,46,-56,102v0,50,8,102,56,102v47,0,56,-45,56,-102v0,-52,-8,-102,-56,-102"},"1":{"d":"48,-30r55,0v2,-63,-5,-134,4,-190v-15,20,-38,32,-59,47r-15,-21r87,-62r16,0r0,226r54,0r0,30r-142,0r0,-30"},"2":{"d":"37,-231v39,-39,151,-38,146,38v-5,68,-52,108,-84,150v-6,6,-15,9,-19,17v31,-7,72,-3,109,-4r0,30r-158,0r0,-13v43,-48,107,-94,117,-174v6,-50,-73,-45,-96,-20"},"3":{"d":"49,-35v39,18,110,14,110,-39v0,-45,-43,-49,-90,-47r0,-13v25,-30,44,-66,74,-91v-30,5,-67,3,-102,3r0,-30r142,0r0,14r-61,82v-4,4,-11,6,-14,11v49,-8,85,20,86,68v2,76,-87,96,-154,72"},"4":{"d":"215,-76r-47,0r0,76r-33,0r0,-76r-121,0r0,-15r130,-165r24,0r0,152r47,0r0,28xm135,-104v-1,-34,1,-75,3,-102v-24,39,-53,75,-86,105v25,-4,54,-3,83,-3"},"5":{"d":"45,-32v42,14,107,6,107,-45v0,-48,-49,-53,-98,-49r0,-126r125,0r0,32r-94,0r0,65v59,-4,101,18,101,76v0,76,-84,98,-150,75"},"6":{"d":"122,-151v50,1,80,26,80,75v0,50,-34,78,-85,81v-110,6,-100,-150,-49,-208v23,-27,54,-48,95,-54r7,28v-59,8,-93,49,-105,104v11,-16,30,-26,57,-26xm117,-24v30,0,47,-19,50,-50v5,-61,-89,-59,-104,-21v-3,43,15,71,54,71"},"7":{"d":"49,0r97,-206r17,-18v-38,8,-89,3,-133,4r0,-32r167,0r0,10r-114,242r-34,0","k":{" ":19,"\u00a0":19,"-":23,"\u00ad":23,"\u2013":23,"\u2014":23,",":40,".":40,"\u2026":40,"C":2,"G":2,"O":2,"Q":2,"\u00c7":2,"\u00d2":2,"\u00d3":2,"\u00d4":2,"\u00d5":2,"\u00d6":2,"\u00d8":2,"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"t":2,"\u00c6":6,"A":4,"\u00c0":4,"\u00c1":4,"\u00c2":4,"\u00c3":4,"\u00c4":4,"\u00c5":4,"a":4,"m":4,"n":4,"p":4,"r":4,"s":4,"u":4,"\u00e6":4}},"8":{"d":"33,-61v0,-37,23,-53,52,-69v-23,-14,-47,-26,-46,-63v2,-43,34,-64,78,-64v41,0,73,20,73,59v0,36,-18,48,-44,66v25,14,50,28,50,65v0,48,-35,72,-84,72v-45,0,-79,-21,-79,-66xm114,-24v43,4,65,-48,32,-73v-10,-9,-25,-14,-38,-21v-24,12,-43,26,-43,52v0,28,21,40,49,42xm157,-192v1,-48,-85,-46,-85,-1v0,30,29,39,52,51v17,-13,32,-25,33,-50"},"9":{"d":"163,-121v-40,42,-142,16,-137,-54v4,-52,34,-80,87,-82v110,-5,99,159,47,215v-23,25,-53,43,-94,47r-8,-27v60,-7,94,-44,105,-99xm111,-229v-31,0,-50,19,-50,51v0,56,82,62,104,28v5,-44,-12,-79,-54,-79"},":":{"d":"60,-138v-14,0,-24,-9,-24,-22v0,-15,9,-23,24,-23v14,0,24,9,24,23v-1,12,-10,22,-24,22xm60,4v-14,0,-24,-9,-24,-22v0,-15,9,-23,24,-23v14,0,24,9,24,23v-1,12,-10,22,-24,22","w":98,"k":{"\/":-7}},";":{"d":"57,-38v52,8,21,92,-16,92r-10,-17v15,-4,27,-18,27,-35v-14,4,-25,-5,-25,-19v0,-12,13,-23,24,-21xm59,-138v-14,0,-23,-9,-24,-22v0,-14,10,-23,24,-23v15,0,25,9,25,23v0,13,-11,22,-25,22","w":99},"<":{"d":"16,-108r0,-14r151,-85r15,26v-42,22,-79,50,-128,65v50,15,87,42,130,63r-15,26","w":199},"=":{"d":"15,-167r169,0r0,30r-169,0r0,-30xm15,-105r169,0r0,30r-169,0r0,-30","w":199},">":{"d":"184,-125r0,13r-152,85r-14,-26v42,-22,79,-50,128,-65v-50,-14,-87,-42,-130,-63r14,-26","w":199},"?":{"d":"158,-197v0,68,-70,66,-72,131r-28,0v-8,-69,59,-70,64,-126v4,-51,-72,-37,-97,-19r-12,-26v42,-30,145,-31,145,40xm74,4v-14,0,-24,-9,-24,-22v0,-15,9,-23,24,-23v14,0,24,9,24,23v-1,12,-10,22,-24,22","w":172},"@":{"d":"64,-87v-4,107,103,159,203,126r8,27v-119,40,-246,-24,-242,-151v5,-112,75,-178,186,-178v98,0,166,50,166,146v0,66,-43,110,-109,114v-32,3,-40,-20,-37,-48v-17,22,-35,48,-72,48v-31,0,-46,-25,-46,-55v0,-76,72,-149,143,-107v7,-6,13,-13,28,-11v-7,43,-23,90,-23,135v0,7,6,10,15,10v46,-4,71,-39,71,-86v0,-80,-57,-117,-138,-117v-91,0,-149,56,-153,147xm154,-63v-4,38,44,39,61,14v21,-21,34,-52,39,-89v-8,-9,-13,-13,-29,-12v-45,4,-66,43,-71,87","w":418},"A":{"d":"165,-66r-100,0r-27,66r-35,0r104,-256r18,0r104,256r-37,0xm76,-96r78,0v-15,-35,-29,-71,-40,-110v-7,42,-24,75,-38,110","w":232},"B":{"d":"32,-250v65,-8,169,-18,169,56v0,36,-25,49,-51,61v34,5,60,23,60,61v0,79,-101,82,-178,70r0,-248xm171,-71v0,-49,-56,-42,-104,-43r0,84v42,7,104,6,104,-41xm163,-187v3,-45,-54,-39,-96,-36r0,81v48,2,93,-3,96,-45","w":230,"k":{"T":11}},"C":{"d":"59,-126v-4,82,76,120,143,87r8,28v-16,12,-42,16,-69,16v-78,0,-118,-50,-120,-131v-3,-105,85,-151,185,-122r-8,31v-12,-6,-30,-8,-54,-8v-57,2,-82,39,-85,99","w":224,"k":{" ":14,"\u00a0":14,"-":28,"\u00ad":28,"\u2013":28,"\u2014":28,"C":9,"G":9,"O":9,"Q":9,"\u00c7":9,"\u00d2":9,"\u00d3":9,"\u00d4":9,"\u00d5":9,"\u00d6":9,"\u00d8":9,"T":10,"V":10,"W":2,"X":15,"Y":13,"\u00dd":13,"Z":9,"c":13,"e":13,"g":13,"o":13,"q":13,"\u00e7":13,"\u00e8":13,"\u00e9":13,"\u00ea":13,"\u00eb":13,"\u00f0":13,"\u00f2":13,"\u00f3":13,"\u00f4":13,"\u00f5":13,"\u00f6":13,"\u00f8":13,"t":13,"v":15,"y":15,"\u00fd":15,"\u00ff":15,"w":14,"x":10,"z":8,"\u00c6":41,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"a":6,"m":6,"n":6,"p":6,"r":6,"s":6,"u":6,"\u00e6":6}},"D":{"d":"237,-128v2,109,-89,147,-205,128r0,-252v22,-4,49,-3,75,-3v84,0,129,45,130,127xm198,-128v0,-73,-49,-106,-130,-94r0,192v80,11,130,-21,130,-98","w":257,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":7,"\u00c0":7,"\u00c1":7,"\u00c2":7,"\u00c3":7,"\u00c4":7,"\u00c5":7}},"E":{"d":"32,-252r152,0r0,31r-116,0r0,77r106,0r0,31r-106,0r0,82r118,0r0,31r-154,0r0,-252","w":210},"F":{"d":"32,-252r152,0r0,31r-116,0r0,80r108,0r0,31r-108,0r0,110r-36,0r0,-252","w":203},"G":{"d":"59,-126v-3,78,63,118,131,90r0,-64r-65,-6r0,-21r95,0r0,111v-18,13,-47,21,-77,21v-80,0,-120,-48,-122,-131v-3,-105,92,-152,190,-121r-8,30v-12,-6,-30,-8,-54,-8v-59,2,-87,38,-90,99","w":240},"H":{"d":"196,-113r-128,0r0,113r-36,0r0,-252r36,0r0,108r128,0r0,-108r36,0r0,252r-36,0r0,-113","w":263},"I":{"d":"54,-228r-29,0r0,-24r93,0r0,24r-28,0r0,204r28,0r0,24r-93,0r0,-24r29,0r0,-204","w":143},"J":{"d":"-6,-32v28,11,51,0,51,-35r0,-185r36,0r0,194v4,52,-47,74,-94,55","w":117},"K":{"d":"86,-114r-18,0r0,114r-36,0r0,-252r36,0r0,116r17,-5r90,-111r41,0r-90,108r-17,12r20,15r100,117r-46,0","w":240,"k":{" ":11,"\u00a0":11,"-":29,"\u00ad":29,"\u2013":29,"\u2014":29,"C":18,"G":18,"O":18,"Q":18,"\u00c7":18,"\u00d2":18,"\u00d3":18,"\u00d4":18,"\u00d5":18,"\u00d6":18,"\u00d8":18,"T":12,"V":2,"W":2,"X":11,"Y":10,"\u00dd":10,"c":17,"e":17,"g":17,"o":17,"q":17,"\u00e7":17,"\u00e8":17,"\u00e9":17,"\u00ea":17,"\u00eb":17,"\u00f0":17,"\u00f2":17,"\u00f3":17,"\u00f4":17,"\u00f5":17,"\u00f6":17,"\u00f8":17,"t":14,"v":19,"y":19,"\u00fd":19,"\u00ff":19,"w":19,"x":14,"z":12,"\u00c6":36,"A":11,"\u00c0":11,"\u00c1":11,"\u00c2":11,"\u00c3":11,"\u00c4":11,"\u00c5":11,"a":10,"m":10,"n":10,"p":10,"r":10,"s":10,"u":10,"\u00e6":10}},"L":{"d":"197,0r-165,0r0,-252r36,0r0,220r129,0r0,32","w":203,"k":{" ":15,"\u00a0":15,"*":58,"-":28,"\u00ad":28,"\u2013":28,"\u2014":28,"C":24,"G":24,"O":24,"Q":24,"\u00c7":24,"\u00d2":24,"\u00d3":24,"\u00d4":24,"\u00d5":24,"\u00d6":24,"\u00d8":24,"T":44,"V":37,"W":26,"X":37,"Y":38,"\u00dd":38,"Z":18,"c":21,"e":21,"g":21,"o":21,"q":21,"\u00e7":21,"\u00e8":21,"\u00e9":21,"\u00ea":21,"\u00eb":21,"\u00f0":21,"\u00f2":21,"\u00f3":21,"\u00f4":21,"\u00f5":21,"\u00f6":21,"\u00f8":21,"t":17,"v":35,"y":35,"\u00fd":35,"\u00ff":35,"w":25,"x":15,"z":12,"\u00c6":28,"\"":45,"'":45,"\u2018":45,"\u2019":45,"\u201c":45,"\u201d":45,"\u00ae":53,"\u2122":53,"A":27,"\u00c0":27,"\u00c1":27,"\u00c2":27,"\u00c3":27,"\u00c4":27,"\u00c5":27,"a":7,"m":7,"n":7,"p":7,"r":7,"s":7,"u":7,"\u00e6":7}},"M":{"d":"244,-162v0,-13,5,-30,3,-41v-23,55,-57,98,-86,147r-11,0v-29,-49,-66,-90,-88,-146r-2,0v11,58,4,135,6,202r-34,0r0,-252r27,0r85,129r14,27v26,-57,63,-104,94,-156r28,0r0,252r-36,0r0,-162","w":312},"N":{"d":"85,-160v-8,-11,-14,-25,-23,-35v8,58,2,130,4,195r-34,0r0,-256r20,0v49,66,105,125,149,197r2,0v-8,-58,-2,-129,-4,-193r34,0r0,256r-21,0","w":264},"O":{"d":"134,5v-78,0,-113,-52,-113,-131v0,-79,36,-131,113,-131v78,0,114,52,114,131v0,79,-36,131,-114,131xm134,-226v-52,0,-77,39,-75,100v2,55,20,100,75,100v53,0,78,-39,76,-100v-2,-55,-20,-100,-76,-100","w":268,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":7,"\u00c0":7,"\u00c1":7,"\u00c2":7,"\u00c3":7,"\u00c4":7,"\u00c5":7}},"P":{"d":"207,-177v-1,71,-63,89,-139,83r0,94r-36,0r0,-249v73,-14,177,-11,175,72xm169,-176v0,-49,-54,-52,-101,-46r0,97v49,5,101,1,101,-51","w":221,"k":{" ":14,"\u00a0":14,",":47,".":47,"\u2026":47,"C":6,"G":6,"O":6,"Q":6,"\u00c7":6,"\u00d2":6,"\u00d3":6,"\u00d4":6,"\u00d5":6,"\u00d6":6,"\u00d8":6,"T":6,"X":15,"Y":9,"\u00dd":9,"Z":10,"c":13,"e":13,"g":13,"o":13,"q":13,"\u00e7":13,"\u00e8":13,"\u00e9":13,"\u00ea":13,"\u00eb":13,"\u00f0":13,"\u00f2":13,"\u00f3":13,"\u00f4":13,"\u00f5":13,"\u00f6":13,"\u00f8":13,"x":13,"z":10,"\u00c6":40,"A":23,"\u00c0":23,"\u00c1":23,"\u00c2":23,"\u00c3":23,"\u00c4":23,"\u00c5":23,"a":13,"m":13,"n":13,"p":13,"r":13,"s":13,"u":13,"\u00e6":13}},"Q":{"d":"83,17v69,-12,124,36,195,17r0,31v-70,20,-129,-28,-195,-17r0,-31xm134,5v-78,0,-113,-52,-113,-131v0,-79,36,-131,113,-131v78,0,114,52,114,131v0,79,-36,131,-114,131xm134,-226v-52,0,-77,39,-75,100v2,55,20,100,75,100v53,0,78,-39,76,-100v-2,-55,-20,-100,-76,-100","w":268,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":7,"\u00c0":7,"\u00c1":7,"\u00c2":7,"\u00c3":7,"\u00c4":7,"\u00c5":7}},"R":{"d":"196,-185v0,45,-28,64,-62,74r19,12r68,99r-42,0r-75,-106r-36,-5r0,111r-36,0r0,-249v68,-12,164,-14,164,64xm158,-183v1,-41,-48,-46,-90,-39r0,87v48,2,90,-2,90,-48","w":235,"k":{"-":14,"\u00ad":14,"\u2013":14,"\u2014":14,"C":13,"G":13,"O":13,"Q":13,"\u00c7":13,"\u00d2":13,"\u00d3":13,"\u00d4":13,"\u00d5":13,"\u00d6":13,"\u00d8":13,"T":22,"V":17,"W":14,"X":14,"Y":20,"\u00dd":20,"Z":9,"c":17,"e":17,"g":17,"o":17,"q":17,"\u00e7":17,"\u00e8":17,"\u00e9":17,"\u00ea":17,"\u00eb":17,"\u00f0":17,"\u00f2":17,"\u00f3":17,"\u00f4":17,"\u00f5":17,"\u00f6":17,"\u00f8":17,"t":9,"v":12,"y":12,"\u00fd":12,"\u00ff":12,"w":10,"x":14,"z":10,"\u00c6":38,"A":9,"\u00c0":9,"\u00c1":9,"\u00c2":9,"\u00c3":9,"\u00c4":9,"\u00c5":9}},"S":{"d":"29,-41v32,18,125,30,127,-25v-13,-69,-130,-31,-132,-123v-1,-73,103,-80,163,-55r-11,31v-30,-16,-115,-26,-116,22v15,67,130,35,132,122v2,81,-112,85,-175,60","w":209},"T":{"d":"213,-220r-85,0r0,220r-36,0r0,-220r-85,0r0,-32r206,0r0,32","w":219,"k":{"\u00ff":46,"\u00fd":46,"\u00f6":46,"\u00f5":46,"\u00f4":46,"\u00f3":46,"\u00f2":46,"\u00ef":28,"\u00ee":28,"\u00eb":46,"\u00ea":46,"\u00e9":46,"\u00e8":46," ":14,"\u00a0":14,"-":46,"\u00ad":46,"\u2013":46,"\u2014":46,",":37,".":37,"\u2026":37,"C":17,"G":17,"O":17,"Q":17,"\u00c7":17,"\u00d2":17,"\u00d3":17,"\u00d4":17,"\u00d5":17,"\u00d6":17,"\u00d8":17,"T":-7,"V":2,"W":2,"X":12,"Y":5,"\u00dd":5,"Z":12,"c":46,"e":46,"g":46,"o":46,"q":46,"\u00e7":46,"\u00f0":46,"\u00f8":46,"t":22,"v":46,"y":46,"w":46,"x":46,"z":46,"\u00c6":42,"A":24,"\u00c0":24,"\u00c1":24,"\u00c2":24,"\u00c3":24,"\u00c4":24,"\u00c5":24,"a":38,"m":38,"n":38,"p":38,"r":38,"s":38,"u":38,"\u00e6":38,")":-10,"]":-10,"}":-10,"\u00e0":28,"\u00e1":28,"\u00e2":28,"\u00e3":28,"\u00e4":28,"\u00e5":28,"\u00ec":28,"\u00ed":28,"\u00f1":28,"\u00f9":28,"\u00fa":28,"\u00fb":28,"\u00fc":28}},"U":{"d":"131,-28v43,0,59,-23,59,-67r0,-157r34,0r0,165v-2,59,-32,90,-92,90v-61,0,-99,-25,-100,-83r0,-172r36,0r0,158v0,46,19,65,63,66","w":255},"V":{"d":"39,-252v26,69,58,132,78,207v16,-77,50,-138,74,-207r36,0r-104,256r-18,0r-106,-256r40,0","w":226,"k":{"\u00f6":21,"\u00f5":21,"\u00ef":17,"\u00ee":17,"\u00ec":17,"\u00eb":21," ":11,"\u00a0":11,"*":-17,"-":19,"\u00ad":19,"\u2013":19,"\u2014":19,",":34,".":34,"\u2026":34,"C":9,"G":9,"O":9,"Q":9,"\u00c7":9,"\u00d2":9,"\u00d3":9,"\u00d4":9,"\u00d5":9,"\u00d6":9,"\u00d8":9,"T":2,"V":2,"W":2,"X":2,"Y":3,"\u00dd":3,"Z":2,"c":21,"e":21,"g":21,"o":21,"q":21,"\u00e7":21,"\u00e8":21,"\u00e9":21,"\u00ea":21,"\u00f0":21,"\u00f2":21,"\u00f3":21,"\u00f4":21,"\u00f8":21,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":6,"x":17,"z":14,"\u00c6":35,"\"":-14,"'":-14,"\u2018":-14,"\u2019":-14,"\u201c":-14,"\u201d":-14,"A":16,"\u00c0":16,"\u00c1":16,"\u00c2":16,"\u00c3":16,"\u00c4":16,"\u00c5":16,"a":18,"m":18,"n":18,"p":18,"r":18,"s":18,"u":18,"\u00e6":18,"\u00e0":17,"\u00e1":17,"\u00e2":17,"\u00e3":17,"\u00e4":17,"\u00e5":17,"\u00ed":17,"\u00f1":17,"\u00f9":17,"\u00fa":17,"\u00fb":17,"\u00fc":17}},"W":{"d":"41,-252v18,69,45,129,54,206v11,-79,42,-137,63,-206r18,0v21,68,51,129,63,206v11,-75,35,-137,52,-206r35,0r-77,256r-20,0v-21,-68,-48,-129,-63,-202r-2,0v-13,75,-42,134,-62,202r-21,0r-78,-256r38,0","w":328,"k":{"\u00ef":11,"\u00ec":11," ":9,"\u00a0":9,"*":-17,"-":9,"\u00ad":9,"\u2013":9,"\u2014":9,",":27,".":27,"\u2026":27,"C":7,"G":7,"O":7,"Q":7,"\u00c7":7,"\u00d2":7,"\u00d3":7,"\u00d4":7,"\u00d5":7,"\u00d6":7,"\u00d8":7,"T":2,"V":2,"W":2,"X":2,"Y":3,"\u00dd":3,"Z":2,"c":15,"e":15,"g":15,"o":15,"q":15,"\u00e7":15,"\u00e8":15,"\u00e9":15,"\u00ea":15,"\u00eb":15,"\u00f0":15,"\u00f2":15,"\u00f3":15,"\u00f4":15,"\u00f5":15,"\u00f6":15,"\u00f8":15,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"w":6,"x":14,"z":13,"\u00c6":30,"\"":-14,"'":-14,"\u2018":-14,"\u2019":-14,"\u201c":-14,"\u201d":-14,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"a":15,"m":15,"n":15,"p":15,"r":15,"s":15,"u":15,"\u00e6":15,"\u00e0":11,"\u00e1":11,"\u00e2":11,"\u00e3":11,"\u00e4":11,"\u00e5":11,"\u00ed":11,"\u00ee":11,"\u00f1":11,"\u00f9":11,"\u00fa":11,"\u00fb":11,"\u00fc":11}},"X":{"d":"101,-128r-83,-124r42,0v22,35,47,65,65,104v16,-40,44,-69,66,-104r39,0r-85,121r89,131r-42,0v-24,-37,-51,-69,-71,-110v-18,42,-48,73,-72,110r-39,0","w":244,"k":{" ":11,"\u00a0":11,"-":29,"\u00ad":29,"\u2013":29,"\u2014":29,"C":18,"G":18,"O":18,"Q":18,"\u00c7":18,"\u00d2":18,"\u00d3":18,"\u00d4":18,"\u00d5":18,"\u00d6":18,"\u00d8":18,"T":12,"V":2,"W":2,"X":11,"Y":10,"\u00dd":10,"c":17,"e":17,"g":17,"o":17,"q":17,"\u00e7":17,"\u00e8":17,"\u00e9":17,"\u00ea":17,"\u00eb":17,"\u00f0":17,"\u00f2":17,"\u00f3":17,"\u00f4":17,"\u00f5":17,"\u00f6":17,"\u00f8":17,"t":14,"v":19,"y":19,"\u00fd":19,"\u00ff":19,"w":19,"x":14,"z":12,"\u00c6":36,"A":11,"\u00c0":11,"\u00c1":11,"\u00c2":11,"\u00c3":11,"\u00c4":11,"\u00c5":11,"a":10,"m":10,"n":10,"p":10,"r":10,"s":10,"u":10,"\u00e6":10}},"Y":{"d":"94,-99r-91,-153r42,0v22,44,55,78,69,130v15,-51,45,-86,67,-130r39,0r-90,153r0,99r-36,0r0,-99","w":222,"k":{"\u00f6":31,"\u00f5":31,"\u00ef":22,"\u00ee":22,"\u00ec":22,"\u00eb":31,"\u00e8":31,"\u00e1":22," ":9,"\u00a0":9,"*":-9,"-":22,"\u00ad":22,"\u2013":22,"\u2014":22,",":39,".":39,"\u2026":39,"C":15,"G":15,"O":15,"Q":15,"\u00c7":15,"\u00d2":15,"\u00d3":15,"\u00d4":15,"\u00d5":15,"\u00d6":15,"\u00d8":15,"T":5,"V":3,"W":2,"X":10,"Y":3,"\u00dd":3,"Z":9,"c":31,"e":31,"g":31,"o":31,"q":31,"\u00e7":31,"\u00e9":31,"\u00ea":31,"\u00f0":31,"\u00f2":31,"\u00f3":31,"\u00f4":31,"\u00f8":31,"t":14,"v":17,"y":17,"\u00fd":17,"\u00ff":17,"w":14,"x":22,"z":23,"\u00c6":35,"\"":-13,"'":-13,"\u2018":-13,"\u2019":-13,"\u201c":-13,"\u201d":-13,"A":24,"\u00c0":24,"\u00c1":24,"\u00c2":24,"\u00c3":24,"\u00c4":24,"\u00c5":24,"a":26,"m":26,"n":26,"p":26,"r":26,"s":26,"u":26,"\u00e6":26,"\u00e0":22,"\u00e2":22,"\u00e3":22,"\u00e4":22,"\u00e5":22,"\u00ed":22,"\u00f1":22,"\u00f9":22,"\u00fa":22,"\u00fb":22,"\u00fc":22}},"Z":{"d":"14,-32r136,-174r17,-14r-153,0r0,-32r187,0r0,32r-137,175r-17,13r154,0r0,32r-187,0r0,-32","w":214,"k":{" ":15,"\u00a0":15,"-":33,"\u00ad":33,"\u2013":33,"\u2014":33,"C":9,"G":9,"O":9,"Q":9,"\u00c7":9,"\u00d2":9,"\u00d3":9,"\u00d4":9,"\u00d5":9,"\u00d6":9,"\u00d8":9,"T":9,"V":2,"W":2,"X":10,"Y":9,"\u00dd":9,"Z":8,"c":18,"e":18,"g":18,"o":18,"q":18,"\u00e7":18,"\u00e8":18,"\u00e9":18,"\u00ea":18,"\u00eb":18,"\u00f0":18,"\u00f2":18,"\u00f3":18,"\u00f4":18,"\u00f5":18,"\u00f6":18,"\u00f8":18,"t":6,"v":11,"y":11,"\u00fd":11,"\u00ff":11,"w":11,"x":8,"z":10,"\u00c6":36,"A":7,"\u00c0":7,"\u00c1":7,"\u00c2":7,"\u00c3":7,"\u00c4":7,"\u00c5":7,"a":8,"m":8,"n":8,"p":8,"r":8,"s":8,"u":8,"\u00e6":8}},"[":{"d":"32,-252r74,0r0,29r-41,0r0,277r41,0r0,29r-74,0r0,-335","w":120,"k":{"-":2,"\u00ad":2,"\u2013":2,"\u2014":2}},"\\":{"d":"159,37r-27,13r-145,-293r27,-13","w":151},"]":{"d":"89,83r-74,0r0,-29r41,0r0,-277r-41,0r0,-29r74,0r0,335","w":120},"^":{"d":"96,-256r13,0r68,101r-35,0v-14,-23,-32,-43,-40,-72v-11,29,-31,49,-48,72r-32,0","w":199},"_":{"d":"0,47r163,0r0,28r-163,0r0,-28","w":162},"`":{"d":"87,-205r-20,0r-45,-46r0,-8r39,0","w":108},"a":{"d":"142,-109v20,-70,-68,-62,-103,-40r-9,-28v47,-23,152,-31,147,45v-3,44,-8,94,2,133r-24,0r-9,-29r-3,0v-23,43,-128,44,-127,-22v1,-60,67,-69,126,-59xm88,-25v37,-2,59,-18,54,-61v-36,-5,-92,-10,-91,32v0,20,16,29,37,29","w":209,"k":{"\u201d":3,"\u201c":3,"\u2019":3,"\u2018":3,"T":43,"'":3,"\"":3}},"b":{"d":"205,-98v0,95,-99,120,-173,88r0,-242r33,0r0,86r3,0v11,-18,31,-28,57,-28v55,1,80,37,80,96xm170,-98v-3,-38,-12,-68,-50,-68v-32,0,-46,21,-55,45r0,89v53,20,110,-1,105,-66","w":226,"k":{"f":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19}},"c":{"d":"57,-94v-8,62,64,90,106,57r11,24v-15,12,-39,18,-65,18v-62,0,-87,-36,-87,-99v0,-86,73,-120,148,-89r-9,27v-48,-22,-110,-8,-104,62","w":190,"k":{"y":4," ":9,"\u00a0":9,"-":17,"\u00ad":17,"\u2013":17,"\u2014":17,"c":8,"e":8,"g":8,"o":8,"q":8,"\u00e7":8,"\u00e8":8,"\u00e9":8,"\u00ea":8,"\u00eb":8,"\u00f0":8,"\u00f2":8,"\u00f3":8,"\u00f4":8,"\u00f5":8,"\u00f6":8,"\u00f8":8,"x":6,"z":6}},"d":{"d":"22,-93v-3,-81,65,-116,139,-93r0,-66r33,0r0,221v0,11,2,22,4,32r-22,0r-9,-29r-3,0v-10,19,-33,33,-62,33v-58,-1,-77,-36,-80,-98xm109,-23v32,0,45,-17,52,-44r0,-87v-43,-27,-112,-5,-105,61v4,39,12,70,53,70","w":226},"e":{"d":"55,-90v-10,68,80,83,118,49r12,26v-17,11,-43,20,-72,20v-62,0,-91,-36,-91,-99v0,-62,30,-100,92,-100v60,0,87,40,76,104r-135,0xm161,-114v8,-54,-55,-63,-87,-40v-10,8,-15,21,-17,40r104,0","w":215,"k":{"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":4,"x":8,"z":4,"\"":3,"'":3,"\u2018":3,"\u2019":3,"\u201c":3,"\u201d":3}},"f":{"d":"138,-223v-29,-12,-74,-10,-64,34r55,0r0,28r-55,0r0,161r-33,0r0,-161r-32,0r0,-28r32,0v-10,-66,48,-79,104,-61","w":131,"k":{"\u00ef":-22,"\u00ee":-9,"\u00ec":-17,"}":-22,"]":-22,"*":-2,"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"t":6,"\"":-2,"'":-2,"\u2018":-2,"\u2019":-2,"\u201c":-2,"\u201d":-2,"\u00ae":-3,"\u2122":-3,")":-22}},"g":{"d":"122,-194v29,0,50,4,71,10r0,185v8,77,-90,86,-151,63r8,-30v45,21,126,20,111,-54r-4,0v-9,13,-31,21,-55,21v-59,0,-80,-31,-80,-94v0,-64,34,-102,100,-101xm57,-94v3,40,13,67,52,67v30,-1,44,-17,51,-41r0,-93v-54,-16,-107,4,-103,67","w":225},"h":{"d":"132,-194v94,-6,61,111,67,194r-33,0v-7,-64,25,-166,-45,-165v-31,1,-49,19,-56,44r0,121r-33,0r0,-252r33,0r0,86r4,0v15,-17,33,-26,63,-28","w":230},"i":{"d":"58,-213v-14,0,-24,-9,-24,-21v0,-12,11,-22,24,-22v12,0,24,10,24,22v0,12,-12,21,-24,21xm41,-189r33,0r0,189r-33,0r0,-189","w":114},"j":{"d":"56,-213v-13,0,-23,-8,-23,-21v0,-13,10,-22,23,-22v12,0,24,10,24,22v0,12,-12,21,-24,21xm4,48v32,1,37,-21,36,-53r0,-184r33,0r0,195v1,49,-21,75,-69,69r0,-27","w":112},"k":{"d":"85,-85r-20,0r0,85r-33,0r0,-252r33,0r0,149r19,-6r62,-80r39,0v-27,29,-46,65,-80,87v39,25,60,68,90,102r-42,0","w":200,"k":{"\u00f8":9,"\u00f6":9,"\u00f5":9,"\u00f4":9,"\u00f3":9,"\u00f2":9,"\u00f0":9,"\u00eb":9,"\u00ea":9,"\u00e9":9,"\u00e8":9,"\u00e7":9,"q":9,"o":9,"g":9,"e":9,"c":9," ":11,"\u00a0":11,"-":17,"\u00ad":17,"\u2013":17,"\u2014":17,"v":3,"y":3,"\u00fd":3,"\u00ff":3,"x":6}},"l":{"d":"118,-2v-35,13,-82,9,-82,-36r0,-214r33,0r0,202v-3,28,23,31,45,23","w":120},"m":{"d":"237,-165v-72,-2,-45,99,-50,165r-33,0v-8,-61,26,-163,-39,-165v-26,0,-43,17,-50,38r0,127r-33,0r0,-189r22,0r7,25v21,-12,33,-30,68,-30v29,0,44,13,52,36v13,-20,34,-35,65,-36v91,-4,58,113,64,194r-34,0v-8,-61,26,-164,-39,-165","w":341},"n":{"d":"132,-194v93,0,62,111,67,194r-33,0v-7,-63,24,-164,-44,-165v-30,-1,-50,17,-57,40r0,125r-33,0r0,-189r23,0r6,25v20,-13,35,-30,71,-30","w":230,"k":{"T":46}},"o":{"d":"114,5v-61,0,-93,-37,-92,-99v1,-62,29,-100,92,-100v62,0,92,39,92,100v0,60,-32,99,-92,99xm114,-166v-41,0,-58,27,-57,72v1,40,16,71,57,71v37,0,56,-23,56,-71v-1,-41,-15,-72,-56,-72","w":227,"k":{"f":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19}},"p":{"d":"205,-99v3,81,-67,123,-140,95r0,76r-33,0r0,-261r22,0r6,24r4,0v11,-17,32,-30,60,-29v59,0,79,33,81,95xm170,-99v-3,-40,-14,-67,-54,-67v-63,0,-50,72,-51,131v45,30,110,1,105,-64","w":226,"k":{"f":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19}},"q":{"d":"22,-93v0,-96,95,-117,171,-88r0,253r-32,0r-1,-93r-4,0v-11,17,-27,25,-54,26v-54,0,-80,-33,-80,-98xm109,-23v31,0,44,-16,51,-43r0,-92v-49,-19,-109,0,-103,64v4,40,12,70,52,71","w":225},"r":{"d":"64,-164v12,-24,39,-36,73,-25r-7,31v-29,-11,-65,1,-65,30r0,128r-33,0r0,-189r23,0r6,25r3,0","w":136,"k":{",":22,".":22,"\u2026":22,"t":-11}},"s":{"d":"29,-39v25,19,115,31,95,-26v-28,-30,-98,-14,-98,-74v0,-65,84,-63,129,-42r-8,28v-22,-15,-104,-27,-85,24v30,27,98,13,98,74v0,67,-92,71,-141,45","w":179},"t":{"d":"140,-7v-38,20,-99,21,-99,-46r0,-108r-32,0r0,-28r32,0r0,-38r33,-9r0,47r57,0r0,28r-57,0r0,97v-6,43,30,47,58,34","w":145,"k":{"-":12,"\u00ad":12,"\u2013":12,"\u2014":12,"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"x":6}},"u":{"d":"98,5v-91,0,-61,-111,-66,-194r33,0v7,63,-25,164,42,166v31,0,47,-21,56,-43r0,-123r33,0r0,135v-1,19,2,38,4,54r-22,0r-9,-31r-3,0v-13,21,-34,36,-68,36","w":231},"v":{"d":"39,-189v21,49,45,95,61,148v14,-54,38,-99,57,-148r36,0r-89,193r-14,0r-90,-193r39,0","w":192,"k":{" ":13,"\u00a0":13,",":26,".":26,"\u2026":26,"v":-3,"y":-3,"\u00fd":-3,"\u00ff":-3,"w":-2,"x":5,"z":4}},"w":{"d":"168,-189v19,48,44,90,57,144r2,0v10,-53,29,-96,44,-144r31,0r-68,193r-18,0v-21,-52,-48,-99,-63,-157v-15,58,-41,105,-61,157r-17,0r-72,-193r36,0v16,48,39,89,47,145r3,0v12,-55,36,-97,54,-145r25,0","w":302,"k":{" ":9,"\u00a0":9,",":22,".":22,"\u2026":22,"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":-2,"y":-2,"\u00fd":-2,"\u00ff":-2,"x":5,"z":6}},"x":{"d":"84,-97r-68,-92r42,0v17,24,38,44,49,74v14,-28,35,-50,53,-74r38,0r-69,91r73,98r-41,0v-19,-26,-41,-50,-56,-81v-14,32,-36,55,-56,81r-38,0","w":213,"k":{" ":11,"\u00a0":11,"-":17,"\u00ad":17,"\u2013":17,"\u2014":17,"c":9,"e":9,"g":9,"o":9,"q":9,"\u00e7":9,"\u00e8":9,"\u00e9":9,"\u00ea":9,"\u00eb":9,"\u00f0":9,"\u00f2":9,"\u00f3":9,"\u00f4":9,"\u00f5":9,"\u00f6":9,"\u00f8":9,"v":3,"y":3,"\u00fd":3,"\u00ff":3,"x":6}},"y":{"d":"42,-189r60,156r4,0v12,-56,32,-104,48,-156r34,0r-76,205v-12,33,-35,69,-82,55r6,-29v31,8,46,-13,51,-41r-84,-190r39,0","w":191,"k":{" ":13,"\u00a0":13,",":26,".":26,"\u2026":26,"v":-3,"y":-3,"\u00fd":-3,"\u00ff":-3,"w":-2,"x":5,"z":4}},"z":{"d":"17,-28r94,-114r25,-19r-119,0r0,-28r149,0r0,28r-94,115r-26,18r120,0r0,28r-149,0r0,-28","w":185,"k":{" ":11,"\u00a0":11,"-":14,"\u00ad":14,"\u2013":14,"\u2014":14,"c":6,"e":6,"g":6,"o":6,"q":6,"\u00e7":6,"\u00e8":6,"\u00e9":6,"\u00ea":6,"\u00eb":6,"\u00f0":6,"\u00f2":6,"\u00f3":6,"\u00f4":6,"\u00f5":6,"\u00f6":6,"\u00f8":6,"v":4,"y":4,"\u00fd":4,"\u00ff":4}},"{":{"d":"126,83v-39,2,-73,0,-73,-39v0,-44,18,-117,-32,-115r0,-27v74,2,-13,-149,69,-154r36,0r0,28v-22,-1,-40,-1,-40,23v0,44,13,110,-28,114r0,3v40,6,28,71,28,116v0,22,18,23,40,22r0,29","w":137,"k":{"-":2,"\u00ad":2,"\u2013":2,"\u2014":2}},"|":{"d":"32,-252r29,0r0,299r-29,0r0,-299","w":92},"}":{"d":"21,-252v40,-3,74,0,74,39v0,44,-19,118,31,114r0,28v-74,-3,15,151,-70,154r-35,0r0,-29v22,1,41,2,41,-22v0,-44,-14,-111,27,-115r0,-3v-40,-4,-27,-71,-27,-115v0,-23,-18,-24,-41,-23r0,-28","w":137},"~":{"d":"68,-153v38,0,75,36,106,7r13,25v-15,9,-27,18,-47,17v-30,0,-43,-20,-72,-20v-18,0,-29,9,-43,18r-13,-25v19,-13,32,-22,56,-22","w":199},"\u00a0":{"w":104,"k":{"*":2,"-":3,"\u00ad":3,"\u2013":3,"\u2014":3,",":5,".":5,"\u2026":5,"T":11,"V":11,"W":7,"X":11,"Y":11,"\u00dd":11,"Z":8,"\"":24,"'":24,"\u2018":24,"\u2019":24,"\u201c":24,"\u201d":24,"A":12,"\u00c0":12,"\u00c1":12,"\u00c2":12,"\u00c3":12,"\u00c4":12,"\u00c5":12}},"\u00a1":{"d":"70,72r-36,0v0,-64,-2,-131,7,-186r22,0v9,55,7,122,7,186xm51,-144v-14,0,-24,-10,-24,-23v1,-13,10,-22,24,-22v14,0,25,8,25,22v0,13,-10,23,-25,23","w":118},"\u00a2":{"d":"142,-23v17,1,31,-7,42,-13r9,24v-13,7,-30,14,-48,16r0,35r-29,0r0,-35v-54,-4,-77,-40,-77,-98v0,-57,26,-93,77,-99r0,-34r29,0r0,34v18,0,32,5,45,10r-10,27v-10,-5,-25,-7,-38,-9r0,142xm120,-165v-57,-1,-63,105,-23,132v6,5,14,7,23,9r0,-141"},"\u00a3":{"d":"23,-30v43,2,58,-44,41,-80r-41,0r0,-29r26,0v-29,-54,2,-118,72,-118v29,0,53,6,72,13r-11,31v-29,-18,-108,-24,-108,28v0,20,7,33,14,46r61,0r0,29r-47,0v13,36,-3,70,-25,85v33,-9,82,-3,123,-5r0,30r-177,0r0,-30"},"\u00a4":{"d":"62,-87v-15,-20,-14,-55,0,-74v-18,-8,-27,-24,-40,-36r19,-20v12,13,27,24,36,41v17,-16,56,-15,74,0v9,-17,24,-28,36,-41r20,20v-13,12,-23,28,-41,36v14,19,15,57,0,74v18,8,28,23,41,35r-20,20v-12,-13,-27,-23,-35,-40v-18,13,-57,15,-75,0v-9,16,-24,27,-36,40r-19,-20v13,-12,22,-28,40,-35xm114,-161v-21,0,-35,17,-35,37v0,21,14,37,35,37v19,0,35,-15,35,-37v0,-21,-16,-37,-35,-37"},"\u00a5":{"d":"48,-119r37,0r-79,-133r42,0v23,43,53,80,70,130v15,-51,45,-86,67,-130r38,0r-78,133r37,0r0,24r-49,0r0,21r49,0r0,24r-49,0r0,50r-36,0r0,-50r-49,0r0,-24r49,0r0,-21r-49,0r0,-24"},"\u00a6":{"d":"32,-77r29,0r0,124r-29,0r0,-124xm61,-129r-29,0r0,-123r29,0r0,123","w":92},"\u00a7":{"d":"44,-36v21,17,108,18,76,-22v-38,-19,-121,-25,-91,-91v5,-11,16,-20,31,-23v-43,-23,-17,-92,40,-85v27,3,47,5,64,13r-9,27v-23,-16,-105,-17,-76,23v40,17,119,24,92,90v-5,12,-17,22,-34,24v48,23,19,85,-37,85v-28,0,-47,-7,-65,-14xm57,-128v0,36,85,52,85,4v0,-28,-36,-27,-58,-37v-13,5,-27,16,-27,33","w":199},"\u00a8":{"d":"42,-215v-11,0,-20,-8,-20,-20v0,-12,9,-20,20,-20v11,0,21,9,21,20v0,11,-10,20,-21,20xm120,-215v-11,0,-21,-9,-21,-20v0,-11,10,-20,21,-20v11,0,20,9,20,20v0,11,-9,20,-20,20","w":161},"\u00a9":{"d":"156,33v-88,0,-137,-50,-137,-137v0,-85,53,-137,137,-137v84,0,137,51,137,137v0,86,-52,137,-137,137xm156,-213v-67,0,-107,40,-107,109v0,69,40,109,107,109v68,0,108,-39,108,-109v0,-69,-40,-109,-108,-109xm125,-104v-4,40,37,56,68,39r9,24v-48,27,-120,3,-111,-63v-5,-62,57,-90,108,-62r-10,25v-30,-16,-69,-6,-64,37","w":312},"\u00aa":{"d":"106,-210v7,-38,-56,-21,-72,-13r-6,-20v30,-12,107,-28,107,26v0,27,-2,57,2,80r-25,0v-5,-34,-23,9,-47,2v-24,-1,-46,-11,-45,-35v2,-38,44,-40,86,-40xm50,-172v8,24,64,15,56,-18v-24,1,-54,-4,-56,18","w":157},"\u00ab":{"d":"87,-94r63,-81r21,19v-18,21,-31,47,-55,62v24,15,39,40,57,61r-21,18xm14,-93r64,-83r21,19v-17,22,-30,48,-55,63v25,14,39,40,58,61r-22,19","w":188},"\u00ac":{"d":"16,-143r168,0r0,72r-31,0r0,-42r-137,0r0,-30","w":199},"\u00ad":{"d":"23,-120r96,0r0,31r-96,0r0,-31","w":141,"k":{" ":29,"\u00a0":29,"*":3,"-":4,"\u00ad":4,"\u2013":4,"\u2014":4,",":45,".":45,"\u2026":45,"T":5,"V":2,"X":3,"Y":3,"\u00dd":3,"\u00c6":3,"\"":44,"'":44,"\u2018":44,"\u2019":44,"\u201c":44,"\u201d":44,")":2,"]":2,"}":2}},"\u00ae":{"d":"135,-52v-64,0,-104,-38,-104,-104v0,-66,40,-104,104,-104v65,0,104,38,104,104v0,66,-40,104,-104,104xm135,-234v-49,1,-77,27,-77,78v1,50,28,79,77,79v50,0,77,-28,77,-79v0,-49,-27,-79,-77,-78xm134,-210v43,-7,54,55,12,57v21,8,26,32,39,47r-24,0r-27,-40r-19,-6r0,46r-20,0r0,-100v8,-2,28,-5,39,-4xm152,-179v-1,-15,-23,-16,-37,-12r0,28v18,0,37,2,37,-16","w":270},"\u00af":{"d":"22,-240r118,0r0,25r-118,0r0,-25","w":161},"\u00b0":{"d":"89,-151v-33,0,-57,-20,-57,-53v0,-33,24,-53,57,-53v34,0,58,19,58,53v0,34,-24,53,-58,53xm89,-231v-16,0,-30,11,-30,27v0,16,14,28,30,27v17,-1,31,-9,31,-27v0,-17,-14,-26,-31,-27","w":168},"\u00b1":{"d":"15,-184r69,0r0,-68r31,0r0,68r69,0r0,30r-69,0r0,45r-31,0r0,-45r-69,0r0,-30xm15,-91r169,0r0,31r-169,0r0,-31","w":199},"\u00b2":{"d":"98,-242v-2,-32,-49,-22,-65,-10r-9,-23v28,-24,108,-25,104,28v-4,46,-38,67,-67,89v20,-6,48,-5,74,-5r0,26r-115,0r0,-15v28,-23,69,-49,78,-90","w":156},"\u00b3":{"d":"32,-166v21,11,76,11,73,-18v-2,-24,-31,-25,-59,-24r0,-9v17,-16,30,-35,50,-48v-21,3,-46,2,-69,2r0,-25r102,0r0,14v-16,17,-30,36,-50,49v32,-5,56,12,56,42v0,48,-67,58,-109,41","w":156},"\u00b4":{"d":"45,-259r37,0r0,8r-40,46r-20,0","w":103},"\u00b5":{"d":"171,-31v-15,34,-89,51,-114,16r-5,0v7,25,12,53,10,87r-34,0r0,-261r34,0v6,64,-24,167,46,167v33,0,55,-22,62,-50r0,-117r33,0v2,64,-5,135,6,189r-22,0r-12,-31r-4,0"},"\u03bc":{"d":"171,-31v-15,34,-89,51,-114,16r-5,0v7,25,12,53,10,87r-34,0r0,-261r34,0v6,64,-24,167,46,167v33,0,55,-22,62,-50r0,-117r33,0v2,64,-5,135,6,189r-22,0r-12,-31r-4,0"},"\u00b6":{"d":"135,-252r29,0r0,299r-29,0r0,-299xm14,-181v0,-47,32,-76,88,-71r0,299r-29,0r0,-158v-38,-3,-59,-33,-59,-70","w":196},"\u00b7":{"d":"52,-86v-14,0,-23,-9,-24,-22v0,-14,10,-23,24,-23v15,0,24,8,24,23v0,13,-10,22,-24,22","w":104},"\u00b8":{"d":"63,50v-3,-12,-18,-13,-35,-15r19,-32r22,0r-10,16v20,4,35,7,35,28v0,29,-39,38,-70,31r3,-12v19,0,36,1,36,-16","w":117},"\u00b9":{"d":"29,-163r41,0v1,-32,-3,-70,3,-97v-10,13,-27,19,-41,28r-11,-21r60,-38r19,0r0,128r37,0r0,26r-108,0r0,-26","w":156},"\u00ba":{"d":"80,-134v-41,0,-62,-21,-62,-61v0,-39,21,-61,62,-61v40,0,62,20,62,61v0,41,-22,61,-62,61xm80,-233v-23,0,-30,12,-30,38v0,25,8,38,30,38v22,0,31,-14,31,-38v0,-26,-8,-38,-31,-38","w":160},"\u00bb":{"d":"101,-96r-62,81r-21,-18v17,-22,30,-48,55,-63v-25,-14,-39,-39,-57,-60r20,-19xm174,-96r-63,82r-22,-19v18,-22,32,-47,56,-63v-25,-14,-39,-40,-58,-61r21,-19","w":188},"\u00bc":{"d":"64,-101v2,-40,-4,-88,3,-123v-11,12,-27,19,-41,28r-12,-21r61,-38r19,0r0,154r-30,0xm310,-33r-32,0r0,33r-29,0r0,-33r-80,0r0,-16r89,-108r20,0r0,100r32,0r0,24xm249,-57v-1,-21,1,-46,2,-61v-13,25,-31,45,-51,63v15,-2,32,-2,49,-2xm247,-257r21,15r-188,247r-22,-17","w":331},"\u00bd":{"d":"64,-101v2,-40,-4,-88,3,-123v-11,12,-27,19,-41,28r-12,-21r61,-38r19,0r0,154r-30,0xm277,-105v0,-32,-49,-22,-64,-10r-10,-24v30,-23,109,-23,104,29v-4,45,-36,67,-67,88v21,-5,49,-4,75,-4r0,26r-116,0r0,-15v28,-23,69,-49,78,-90xm247,-257r21,15r-188,247r-22,-17","w":336},"\u00be":{"d":"324,-33r-32,0r0,33r-28,0r0,-33r-81,0r0,-16r89,-108r20,0r0,100r32,0r0,24xm264,-57v-1,-20,1,-45,1,-61v-12,26,-31,45,-50,63v15,-2,32,-2,49,-2xm28,-130v21,11,76,11,73,-18v-2,-24,-31,-25,-59,-24r0,-9v17,-16,30,-36,51,-48v-21,3,-46,2,-70,2r0,-25r102,0r0,14v-16,17,-30,36,-50,49v32,-5,56,12,56,42v0,48,-67,58,-109,41xm261,-257r22,15r-189,247r-22,-17","w":346},"\u00bf":{"d":"14,16v0,-69,70,-65,72,-130r28,0v8,69,-59,69,-64,125v-4,50,71,37,97,19r12,25v-41,31,-145,34,-145,-39xm98,-144v-14,0,-24,-10,-24,-23v1,-13,10,-22,24,-22v14,0,24,8,24,22v0,14,-9,23,-24,23","w":172},"\u00c0":{"d":"126,-271r-31,0r-63,-34r0,-8r48,0xm165,-66r-100,0r-27,66r-35,0r104,-256r18,0r104,256r-37,0xm76,-96r78,0v-15,-35,-29,-71,-40,-110v-7,42,-24,75,-38,110","w":232},"\u00c1":{"d":"152,-313r47,0r0,8v-30,12,-47,38,-93,34xm165,-66r-100,0r-27,66r-35,0r104,-256r18,0r104,256r-37,0xm76,-96r78,0v-15,-35,-29,-71,-40,-110v-7,42,-24,75,-38,110","w":232},"\u00c2":{"d":"104,-313r26,0r50,36r0,9r-33,0v-11,-9,-25,-15,-30,-30v-6,15,-21,21,-33,30r-33,0r0,-10xm165,-66r-100,0r-27,66r-35,0r104,-256r18,0r104,256r-37,0xm76,-96r78,0v-15,-35,-29,-71,-40,-110v-7,42,-24,75,-38,110","w":232},"\u00c3":{"d":"180,-282v-30,38,-88,-15,-118,15r-9,-18v24,-30,63,-16,97,-7v8,-1,15,-3,21,-8xm165,-66r-100,0r-27,66r-35,0r104,-256r18,0r104,256r-37,0xm76,-96r78,0v-15,-35,-29,-71,-40,-110v-7,42,-24,75,-38,110","w":232},"\u00c4":{"d":"77,-269v-13,0,-22,-6,-22,-17v0,-12,10,-18,22,-18v13,0,22,6,22,18v0,11,-9,17,-22,17xm154,-269v-13,0,-22,-6,-22,-17v0,-12,10,-18,22,-18v13,0,22,6,22,18v0,11,-9,17,-22,17xm165,-66r-100,0r-27,66r-35,0r104,-256r18,0r104,256r-37,0xm76,-96r78,0v-15,-35,-29,-71,-40,-110v-7,42,-24,75,-38,110","w":232},"\u00c5":{"d":"103,-247v-15,-3,-29,-10,-29,-30v0,-21,16,-32,42,-31v25,0,42,8,43,31v0,20,-14,26,-30,30r100,247r-37,0r-27,-66r-100,0r-27,66r-35,0xm76,-96r78,0v-15,-35,-29,-71,-40,-110v-7,42,-24,75,-38,110xm116,-291v-10,0,-17,5,-17,14v0,9,6,13,17,13v12,0,18,-4,18,-13v0,-9,-7,-14,-18,-14","w":232},"\u00c6":{"d":"154,-213v-12,47,-40,78,-62,115r64,0v-2,-37,4,-82,-2,-115xm156,-68r-83,0r-43,68r-39,0r164,-252r153,0r0,31r-116,0r0,77r106,0r0,31r-106,0r0,82r118,0r0,31r-154,0r0,-68","w":334},"\u00c7":{"d":"59,-126v-4,82,77,120,143,87r8,28v-14,11,-32,13,-55,15r-8,15v20,4,34,8,34,28v0,29,-39,38,-70,31r3,-12v18,0,38,1,36,-16v-2,-12,-18,-13,-35,-15r18,-31v-73,-5,-110,-52,-112,-130v-3,-105,85,-151,185,-122r-8,31v-12,-6,-30,-8,-54,-8v-57,2,-82,39,-85,99","w":224,"k":{" ":14,"\u00a0":14,"-":28,"\u00ad":28,"\u2013":28,"\u2014":28,"C":9,"G":9,"O":9,"Q":9,"\u00c7":9,"\u00d2":9,"\u00d3":9,"\u00d4":9,"\u00d5":9,"\u00d6":9,"\u00d8":9,"T":10,"V":10,"W":2,"X":15,"Y":13,"\u00dd":13,"Z":9,"c":13,"e":13,"g":13,"o":13,"q":13,"\u00e7":13,"\u00e8":13,"\u00e9":13,"\u00ea":13,"\u00eb":13,"\u00f0":13,"\u00f2":13,"\u00f3":13,"\u00f4":13,"\u00f5":13,"\u00f6":13,"\u00f8":13,"t":13,"v":15,"y":15,"\u00fd":15,"\u00ff":15,"w":14,"x":10,"z":8,"\u00c6":41,"A":10,"\u00c0":10,"\u00c1":10,"\u00c2":10,"\u00c3":10,"\u00c4":10,"\u00c5":10,"a":6,"m":6,"n":6,"p":6,"r":6,"s":6,"u":6,"\u00e6":6}},"\u00c8":{"d":"130,-271r-31,0r-62,-34r0,-8r47,0xm32,-252r152,0r0,31r-116,0r0,77r106,0r0,31r-106,0r0,82r118,0r0,31r-154,0r0,-252","w":210},"\u00c9":{"d":"128,-313r48,0r0,8v-31,12,-47,38,-94,34xm32,-252r152,0r0,31r-116,0r0,77r106,0r0,31r-106,0r0,82r118,0r0,31r-154,0r0,-252","w":210},"\u00ca":{"d":"94,-313r26,0r50,36r0,9r-33,0v-11,-9,-25,-15,-30,-30v-6,15,-21,21,-33,30r-33,0r0,-10xm32,-252r152,0r0,31r-116,0r0,77r106,0r0,31r-106,0r0,82r118,0r0,31r-154,0r0,-252","w":210},"\u00cb":{"d":"67,-269v-13,0,-22,-6,-22,-17v0,-12,10,-18,22,-18v13,0,23,5,23,18v0,12,-10,17,-23,17xm144,-269v-13,0,-22,-6,-22,-17v0,-12,10,-18,22,-18v13,0,23,5,23,18v0,12,-10,17,-23,17xm32,-252r152,0r0,31r-116,0r0,77r106,0r0,31r-106,0r0,82r118,0r0,31r-154,0r0,-252","w":210},"\u00cc":{"d":"92,-271r-31,0r-62,-34r0,-8r47,0xm54,-228r-29,0r0,-24r93,0r0,24r-28,0r0,204r28,0r0,24r-93,0r0,-24r29,0r0,-204","w":143},"\u00cd":{"d":"98,-313r48,0r0,8v-30,12,-47,38,-93,34xm54,-228r-29,0r0,-24r93,0r0,24r-28,0r0,204r28,0r0,24r-93,0r0,-24r29,0r0,-204","w":143},"\u00ce":{"d":"60,-313r26,0r50,36r0,9r-33,0v-12,-9,-25,-16,-31,-30v-5,15,-20,21,-32,30r-33,0r0,-10xm54,-228r-29,0r0,-24r93,0r0,24r-28,0r0,204r28,0r0,24r-93,0r0,-24r29,0r0,-204","w":143},"\u00cf":{"d":"33,-269v-13,0,-22,-6,-22,-17v0,-12,10,-18,22,-18v13,0,23,5,23,18v0,12,-10,17,-23,17xm110,-269v-13,0,-22,-6,-22,-17v0,-12,10,-18,22,-18v13,0,23,5,23,18v0,12,-10,17,-23,17xm54,-228r-29,0r0,-24r93,0r0,24r-28,0r0,204r28,0r0,24r-93,0r0,-24r29,0r0,-204","w":143},"\u00d0":{"d":"239,-128v2,110,-89,146,-204,128r0,-118r-35,0r0,-24r35,0r0,-110v22,-4,49,-3,75,-3v84,0,127,45,129,127xm201,-128v0,-73,-50,-106,-130,-94r0,80r58,0r0,24r-58,0r0,88v80,11,130,-21,130,-98","w":260,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":7,"\u00c0":7,"\u00c1":7,"\u00c2":7,"\u00c3":7,"\u00c4":7,"\u00c5":7}},"\u00d1":{"d":"195,-282v-29,38,-88,-15,-118,15r-9,-18v24,-30,63,-15,98,-7v8,-1,15,-3,20,-8xm85,-160v-8,-11,-14,-25,-23,-35v8,58,2,130,4,195r-34,0r0,-256r20,0v49,66,105,125,149,197r2,0v-8,-58,-2,-129,-4,-193r34,0r0,256r-21,0","w":264},"\u00d2":{"d":"162,-271r-31,0r-63,-34r0,-8r48,0xm134,5v-78,0,-113,-52,-113,-131v0,-79,36,-131,113,-131v78,0,114,52,114,131v0,79,-36,131,-114,131xm134,-226v-52,0,-77,39,-75,100v2,55,20,100,75,100v53,0,78,-39,76,-100v-2,-55,-20,-100,-76,-100","w":268,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":7,"\u00c0":7,"\u00c1":7,"\u00c2":7,"\u00c3":7,"\u00c4":7,"\u00c5":7}},"\u00d3":{"d":"160,-313r47,0r0,8v-30,12,-47,38,-93,34xm134,5v-78,0,-113,-52,-113,-131v0,-79,36,-131,113,-131v78,0,114,52,114,131v0,79,-36,131,-114,131xm134,-226v-52,0,-77,39,-75,100v2,55,20,100,75,100v53,0,78,-39,76,-100v-2,-55,-20,-100,-76,-100","w":268,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":7,"\u00c0":7,"\u00c1":7,"\u00c2":7,"\u00c3":7,"\u00c4":7,"\u00c5":7}},"\u00d4":{"d":"122,-313r26,0r50,36r0,9r-33,0v-12,-9,-26,-15,-31,-30v-5,15,-20,21,-32,30r-33,0r0,-10xm134,5v-78,0,-113,-52,-113,-131v0,-79,36,-131,113,-131v78,0,114,52,114,131v0,79,-36,131,-114,131xm134,-226v-52,0,-77,39,-75,100v2,55,20,100,75,100v53,0,78,-39,76,-100v-2,-55,-20,-100,-76,-100","w":268,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":7,"\u00c0":7,"\u00c1":7,"\u00c2":7,"\u00c3":7,"\u00c4":7,"\u00c5":7}},"\u00d5":{"d":"197,-282v-30,38,-88,-15,-118,15r-9,-18v24,-30,63,-16,97,-7v9,-1,16,-3,21,-8xm134,5v-78,0,-113,-52,-113,-131v0,-79,36,-131,113,-131v78,0,114,52,114,131v0,79,-36,131,-114,131xm134,-226v-52,0,-77,39,-75,100v2,55,20,100,75,100v53,0,78,-39,76,-100v-2,-55,-20,-100,-76,-100","w":268,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":7,"\u00c0":7,"\u00c1":7,"\u00c2":7,"\u00c3":7,"\u00c4":7,"\u00c5":7}},"\u00d6":{"d":"95,-269v-13,0,-22,-6,-22,-17v0,-12,10,-18,22,-18v13,0,23,5,23,18v0,12,-10,17,-23,17xm172,-269v-13,0,-22,-6,-22,-17v0,-12,10,-18,22,-18v13,0,23,5,23,18v0,12,-10,17,-23,17xm134,5v-78,0,-113,-52,-113,-131v0,-79,36,-131,113,-131v78,0,114,52,114,131v0,79,-36,131,-114,131xm134,-226v-52,0,-77,39,-75,100v2,55,20,100,75,100v53,0,78,-39,76,-100v-2,-55,-20,-100,-76,-100","w":268,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":7,"\u00c0":7,"\u00c1":7,"\u00c2":7,"\u00c3":7,"\u00c4":7,"\u00c5":7}},"\u00d7":{"d":"50,-189r50,46r50,-46r21,22r-49,45r49,45r-21,23r-50,-47r-50,47r-21,-22r49,-46r-48,-45","w":199},"\u00d8":{"d":"248,-126v-2,79,-36,129,-114,131v-27,0,-49,-7,-67,-19r-14,19r-22,-17r17,-21v-18,-22,-27,-53,-27,-93v2,-79,36,-131,113,-131v29,0,51,8,69,20r16,-20r21,15r-18,25v18,23,26,51,26,91xm181,-208v-53,-44,-122,-1,-122,82v0,25,5,45,13,61xm89,-42v56,40,130,-2,121,-84v-3,-23,-4,-44,-12,-59","w":268,"k":{",":11,".":11,"\u2026":11,"T":17,"V":9,"W":7,"X":18,"Y":15,"\u00dd":15,"Z":9,"v":6,"y":6,"\u00fd":6,"\u00ff":6,"x":11,"z":8,"\u00c6":18,"\"":14,"'":14,"\u2018":14,"\u2019":14,"\u201c":14,"\u201d":14,"A":7,"\u00c0":7,"\u00c1":7,"\u00c2":7,"\u00c3":7,"\u00c4":7,"\u00c5":7}},"\u00d9":{"d":"161,-271r-31,0r-63,-34r0,-8r48,0xm131,-28v43,0,59,-23,59,-67r0,-157r34,0r0,165v-2,59,-32,90,-92,90v-61,0,-99,-25,-100,-83r0,-172r36,0r0,158v0,46,19,65,63,66","w":255},"\u00da":{"d":"153,-313r47,0r0,8v-30,12,-47,38,-93,34xm131,-28v43,0,59,-23,59,-67r0,-157r34,0r0,165v-2,59,-32,90,-92,90v-61,0,-99,-25,-100,-83r0,-172r36,0r0,158v0,46,19,65,63,66","w":255},"\u00db":{"d":"117,-313r27,0r50,36r0,9r-33,0v-12,-9,-26,-15,-31,-30v-6,15,-21,21,-33,30r-32,0r0,-10xm131,-28v43,0,59,-23,59,-67r0,-157r34,0r0,165v-2,59,-32,90,-92,90v-61,0,-99,-25,-100,-83r0,-172r36,0r0,158v0,46,19,65,63,66","w":255},"\u00dc":{"d":"90,-269v-13,0,-22,-6,-22,-17v0,-12,10,-18,22,-18v13,0,23,5,23,18v0,12,-10,17,-23,17xm167,-269v-13,0,-22,-6,-22,-17v0,-12,10,-18,22,-18v13,0,23,5,23,18v0,12,-10,17,-23,17xm131,-28v43,0,59,-23,59,-67r0,-157r34,0r0,165v-2,59,-32,90,-92,90v-61,0,-99,-25,-100,-83r0,-172r36,0r0,158v0,46,19,65,63,66","w":255},"\u00dd":{"d":"138,-313r48,0r0,8v-30,12,-47,38,-93,34xm94,-99r-91,-153r42,0v22,44,55,78,69,130v15,-51,45,-86,67,-130r39,0r-90,153r0,99r-36,0r0,-99","w":222,"k":{"\u00f6":31,"\u00f5":31,"\u00ef":22,"\u00ee":22,"\u00ec":22,"\u00eb":31,"\u00e8":31,"\u00e1":22," ":9,"\u00a0":9,"*":-9,"-":22,"\u00ad":22,"\u2013":22,"\u2014":22,",":39,".":39,"\u2026":39,"C":15,"G":15,"O":15,"Q":15,"\u00c7":15,"\u00d2":15,"\u00d3":15,"\u00d4":15,"\u00d5":15,"\u00d6":15,"\u00d8":15,"T":5,"V":3,"W":2,"X":10,"Y":3,"\u00dd":3,"Z":9,"c":31,"e":31,"g":31,"o":31,"q":31,"\u00e7":31,"\u00e9":31,"\u00ea":31,"\u00f0":31,"\u00f2":31,"\u00f3":31,"\u00f4":31,"\u00f8":31,"t":14,"v":17,"y":17,"\u00fd":17,"\u00ff":17,"w":14,"x":22,"z":23,"\u00c6":35,"\"":-13,"'":-13,"\u2018":-13,"\u2019":-13,"\u201c":-13,"\u201d":-13,"A":24,"\u00c0":24,"\u00c1":24,"\u00c2":24,"\u00c3":24,"\u00c4":24,"\u00c5":24,"a":26,"m":26,"n":26,"p":26,"r":26,"s":26,"u":26,"\u00e6":26,"\u00e0":22,"\u00e2":22,"\u00e3":22,"\u00e4":22,"\u00e5":22,"\u00ed":22,"\u00f1":22,"\u00f9":22,"\u00fa":22,"\u00fb":22,"\u00fc":22}},"\u00de":{"d":"207,-177v0,71,-63,89,-139,83r0,94r-36,0r0,-288r36,0r0,34v71,-5,139,7,139,77xm169,-176v0,-49,-54,-52,-101,-46r0,97v49,5,101,1,101,-51","w":221,"k":{" ":14,"\u00a0":14,",":47,".":47,"\u2026":47,"C":6,"G":6,"O":6,"Q":6,"\u00c7":6,"\u00d2":6,"\u00d3":6,"\u00d4":6,"\u00d5":6,"\u00d6":6,"\u00d8":6,"T":6,"X":15,"Y":9,"\u00dd":9,"Z":10,"c":13,"e":13,"g":13,"o":13,"q":13,"\u00e7":13,"\u00e8":13,"\u00e9":13,"\u00ea":13,"\u00eb":13,"\u00f0":13,"\u00f2":13,"\u00f3":13,"\u00f4":13,"\u00f5":13,"\u00f6":13,"\u00f8":13,"x":13,"z":10,"\u00c6":40,"A":23,"\u00c0":23,"\u00c1":23,"\u00c2":23,"\u00c3":23,"\u00c4":23,"\u00c5":23,"a":13,"m":13,"n":13,"p":13,"r":13,"s":13,"u":13,"\u00e6":13}},"\u00df":{"d":"138,-222v-29,-12,-72,-10,-63,32r0,190r-34,0r0,-161r-32,0r0,-28r32,0v-9,-63,50,-79,105,-60xm125,-39v25,19,115,31,95,-26v-28,-30,-98,-14,-98,-74v0,-65,84,-63,129,-42r-8,28v-22,-15,-104,-27,-85,24v30,27,98,13,98,74v0,67,-92,71,-141,45","w":276},"\u00e0":{"d":"142,-109v20,-70,-68,-62,-103,-40r-9,-28v47,-23,152,-31,147,45v-3,44,-8,94,2,133r-24,0r-9,-29r-3,0v-23,43,-128,44,-127,-22v1,-60,67,-69,126,-59xm88,-25v37,-2,59,-18,54,-61v-36,-5,-92,-10,-91,32v0,20,16,29,37,29xm123,-205r-20,0r-45,-46r0,-8r39,0","w":209},"\u00e1":{"d":"142,-109v20,-70,-68,-62,-103,-40r-9,-28v47,-23,152,-31,147,45v-3,44,-8,94,2,133r-24,0r-9,-29r-3,0v-23,43,-128,44,-127,-22v1,-60,67,-69,126,-59xm88,-25v37,-2,59,-18,54,-61v-36,-5,-92,-10,-91,32v0,20,16,29,37,29xm96,-259r37,0r0,8r-40,46r-20,0","w":209},"\u00e2":{"d":"99,-278r15,0v15,25,29,43,45,67r-29,0v-10,-15,-20,-31,-26,-50v-7,19,-17,35,-28,50r-27,0xm142,-109v20,-70,-68,-62,-103,-40r-9,-28v47,-23,152,-31,147,45v-3,44,-8,94,2,133r-24,0r-9,-29r-3,0v-23,43,-128,44,-127,-22v1,-60,67,-69,126,-59xm88,-25v37,-2,59,-18,54,-61v-36,-5,-92,-10,-91,32v0,20,16,29,37,29","w":209},"\u00e3":{"d":"127,-230v-26,0,-51,-30,-73,-5r-8,-16v17,-25,51,-24,75,-8v13,4,22,3,32,-6r8,17v-9,10,-19,18,-34,18xm142,-109v20,-70,-68,-62,-103,-40r-9,-28v47,-23,152,-31,147,45v-3,44,-8,94,2,133r-24,0r-9,-29r-3,0v-23,43,-128,44,-127,-22v1,-60,67,-69,126,-59xm88,-25v37,-2,59,-18,54,-61v-36,-5,-92,-10,-91,32v0,20,16,29,37,29","w":209},"\u00e4":{"d":"142,-109v20,-70,-68,-62,-103,-40r-9,-28v47,-23,152,-31,147,45v-3,44,-8,94,2,133r-24,0r-9,-29r-3,0v-23,43,-128,44,-127,-22v1,-60,67,-69,126,-59xm88,-25v37,-2,59,-18,54,-61v-36,-5,-92,-10,-91,32v0,20,16,29,37,29xm60,-215v-11,0,-20,-8,-20,-20v0,-12,9,-20,20,-20v11,0,21,9,21,20v0,11,-10,20,-21,20xm138,-215v-11,0,-21,-9,-21,-20v0,-11,10,-20,21,-20v11,0,20,9,20,20v0,11,-9,20,-20,20","w":209},"\u00e5":{"d":"104,-212v-23,1,-40,-12,-40,-34v0,-21,17,-34,40,-34v23,0,41,11,40,34v-1,22,-18,33,-40,34xm104,-262v-10,0,-19,5,-19,16v0,10,9,16,19,16v11,0,20,-5,20,-16v1,-11,-10,-16,-20,-16xm142,-109v20,-70,-68,-62,-103,-40r-9,-28v47,-23,152,-31,147,45v-3,44,-8,94,2,133r-24,0r-9,-29r-3,0v-23,43,-128,44,-127,-22v1,-60,67,-69,126,-59xm88,-25v37,-2,59,-18,54,-61v-36,-5,-92,-10,-91,32v0,20,16,29,37,29","w":209},"\u00e6":{"d":"51,-54v4,46,82,32,92,0r0,-31v-38,-1,-88,-4,-92,31xm175,-91v-9,68,74,85,118,54r12,22v-39,29,-130,27,-149,-18r-4,0v-24,43,-136,55,-136,-17v0,-59,68,-56,127,-59v4,-36,-2,-59,-42,-56v-22,2,-45,6,-62,13r-9,-24v35,-18,117,-29,137,9v46,-54,174,-25,143,76r-135,0xm280,-114v9,-53,-54,-64,-86,-40v-10,8,-16,21,-18,40r104,0","w":334},"\u00e7":{"d":"57,-94v-8,62,62,89,106,57r11,24v-14,11,-35,17,-58,18r-9,14v20,4,34,8,35,28v0,29,-39,38,-70,31r3,-12v19,0,36,1,36,-16v-3,-12,-18,-13,-35,-15r18,-31v-51,-5,-69,-42,-72,-98v-4,-85,73,-120,148,-89r-9,27v-48,-22,-110,-8,-104,62","w":190,"k":{"y":4," ":9,"\u00a0":9,"-":17,"\u00ad":17,"\u2013":17,"\u2014":17,"c":8,"e":8,"g":8,"o":8,"q":8,"\u00e7":8,"\u00e8":8,"\u00e9":8,"\u00ea":8,"\u00eb":8,"\u00f0":8,"\u00f2":8,"\u00f3":8,"\u00f4":8,"\u00f5":8,"\u00f6":8,"\u00f8":8,"x":6,"z":6}},"\u00e8":{"d":"55,-90v-10,68,80,83,118,49r12,26v-17,11,-43,20,-72,20v-62,0,-91,-36,-91,-99v0,-62,30,-100,92,-100v60,0,87,40,76,104r-135,0xm161,-114v8,-54,-55,-63,-87,-40v-10,8,-15,21,-17,40r104,0xm135,-205r-20,0r-45,-46r0,-8r39,0","w":215,"k":{"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":4,"x":8,"z":4,"\"":3,"'":3,"\u2018":3,"\u2019":3,"\u201c":3,"\u201d":3}},"\u00e9":{"d":"55,-90v-10,68,80,83,118,49r12,26v-17,11,-43,20,-72,20v-62,0,-91,-36,-91,-99v0,-62,30,-100,92,-100v60,0,87,40,76,104r-135,0xm161,-114v8,-54,-55,-63,-87,-40v-10,8,-15,21,-17,40r104,0xm119,-259r37,0r0,8r-40,46r-20,0","w":215,"k":{"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":4,"x":8,"z":4,"\"":3,"'":3,"\u2018":3,"\u2019":3,"\u201c":3,"\u201d":3}},"\u00ea":{"d":"102,-278r15,0r45,67r-29,0v-10,-15,-19,-31,-25,-50v-8,18,-18,35,-29,50r-27,0xm55,-90v-10,68,80,83,118,49r12,26v-17,11,-43,20,-72,20v-62,0,-91,-36,-91,-99v0,-62,30,-100,92,-100v60,0,87,40,76,104r-135,0xm161,-114v8,-54,-55,-63,-87,-40v-10,8,-15,21,-17,40r104,0","w":215,"k":{"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":4,"x":8,"z":4,"\"":3,"'":3,"\u2018":3,"\u2019":3,"\u201c":3,"\u201d":3}},"\u00eb":{"d":"55,-90v-10,68,80,83,118,49r12,26v-17,11,-43,20,-72,20v-62,0,-91,-36,-91,-99v0,-62,30,-100,92,-100v60,0,87,40,76,104r-135,0xm161,-114v8,-54,-55,-63,-87,-40v-10,8,-15,21,-17,40r104,0xm77,-215v-11,0,-20,-8,-20,-20v0,-12,9,-20,20,-20v11,0,21,9,21,20v0,11,-10,20,-21,20xm155,-215v-11,0,-21,-9,-21,-20v0,-11,10,-20,21,-20v11,0,20,9,20,20v0,11,-9,20,-20,20","w":215,"k":{"c":4,"e":4,"g":4,"o":4,"q":4,"\u00e7":4,"\u00e8":4,"\u00e9":4,"\u00ea":4,"\u00eb":4,"\u00f0":4,"\u00f2":4,"\u00f3":4,"\u00f4":4,"\u00f5":4,"\u00f6":4,"\u00f8":4,"v":8,"y":8,"\u00fd":8,"\u00ff":8,"w":4,"x":8,"z":4,"\"":3,"'":3,"\u2018":3,"\u2019":3,"\u201c":3,"\u201d":3}},"\u00ec":{"d":"41,-189r33,0r0,189r-33,0r0,-189xm69,-205r-20,0r-45,-46r0,-8r39,0","w":114},"\u00ed":{"d":"41,-189r33,0r0,189r-33,0r0,-189xm63,-259r37,0r0,8r-40,46r-20,0","w":114},"\u00ee":{"d":"50,-278r15,0v15,25,29,43,45,67r-29,0v-10,-15,-20,-31,-26,-50v-7,19,-17,35,-28,50r-27,0xm41,-189r33,0r0,189r-33,0r0,-189","w":114},"\u00ef":{"d":"41,-189r33,0r0,189r-33,0r0,-189xm19,-215v-11,0,-20,-8,-20,-20v0,-12,9,-20,20,-20v11,0,21,9,21,20v0,11,-10,20,-21,20xm97,-215v-11,0,-21,-9,-21,-20v0,-11,10,-20,21,-20v11,0,20,9,20,20v0,11,-9,20,-20,20","w":114,"k":{"\u2122":-11,"\u00ae":-11}},"\u00f0":{"d":"22,-94v-4,-80,89,-123,149,-80v0,-25,-27,-53,-51,-62r-15,28r-19,-8r15,-27v-12,-3,-27,-4,-42,-4r0,-23v20,0,38,1,54,5r14,-25r18,9r-13,23v53,20,79,70,79,144v0,69,-28,119,-95,119v-62,0,-91,-38,-94,-99xm120,-163v-44,-1,-63,27,-63,70v-1,42,22,70,61,70v50,0,61,-46,59,-102v-1,-31,-27,-37,-57,-38","w":232},"\u00f1":{"d":"137,-230v-26,0,-51,-30,-74,-5r-7,-16v17,-25,50,-24,74,-8v13,4,22,3,33,-6r8,17v-10,10,-20,18,-34,18xm132,-194v93,0,62,111,67,194r-33,0v-7,-63,24,-164,-44,-165v-30,-1,-50,17,-57,40r0,125r-33,0r0,-189r23,0r6,25v20,-13,35,-30,71,-30","w":230},"\u00f2":{"d":"114,5v-61,0,-93,-37,-92,-99v1,-62,29,-100,92,-100v62,0,92,39,92,100v0,60,-32,99,-92,99xm114,-166v-41,0,-58,27,-57,72v1,40,16,71,57,71v37,0,56,-23,56,-71v-1,-41,-15,-72,-56,-72xm130,-205r-20,0r-45,-46r0,-8r39,0","w":227,"k":{"f":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19}},"\u00f3":{"d":"114,5v-61,0,-93,-37,-92,-99v1,-62,29,-100,92,-100v62,0,92,39,92,100v0,60,-32,99,-92,99xm114,-166v-41,0,-58,27,-57,72v1,40,16,71,57,71v37,0,56,-23,56,-71v-1,-41,-15,-72,-56,-72xm117,-259r37,0r0,8r-40,46r-20,0","w":227,"k":{"f":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19}},"\u00f4":{"d":"108,-278r14,0r45,67r-28,0v-11,-15,-21,-30,-26,-50v-7,19,-17,35,-28,50r-28,0xm114,5v-61,0,-93,-37,-92,-99v1,-62,29,-100,92,-100v62,0,92,39,92,100v0,60,-32,99,-92,99xm114,-166v-41,0,-58,27,-57,72v1,40,16,71,57,71v37,0,56,-23,56,-71v-1,-41,-15,-72,-56,-72","w":227,"k":{"f":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19}},"\u00f5":{"d":"137,-230v-26,0,-51,-30,-74,-5r-7,-16v17,-25,50,-24,74,-8v13,4,22,3,33,-6r8,17v-10,10,-20,18,-34,18xm114,5v-61,0,-93,-37,-92,-99v1,-62,29,-100,92,-100v62,0,92,39,92,100v0,60,-32,99,-92,99xm114,-166v-41,0,-58,27,-57,72v1,40,16,71,57,71v37,0,56,-23,56,-71v-1,-41,-15,-72,-56,-72","w":227,"k":{"f":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19}},"\u00f6":{"d":"114,5v-61,0,-93,-37,-92,-99v1,-62,29,-100,92,-100v62,0,92,39,92,100v0,60,-32,99,-92,99xm114,-166v-41,0,-58,27,-57,72v1,40,16,71,57,71v37,0,56,-23,56,-71v-1,-41,-15,-72,-56,-72xm70,-215v-11,0,-20,-8,-20,-20v0,-12,9,-20,20,-20v11,0,21,9,21,20v0,11,-10,20,-21,20xm148,-215v-11,0,-21,-9,-21,-20v0,-11,10,-20,21,-20v11,0,20,9,20,20v0,11,-9,20,-20,20","w":227,"k":{"f":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19}},"\u00f7":{"d":"15,-136r169,0r0,30r-169,0r0,-30xm100,-166v-14,0,-24,-10,-24,-23v0,-14,10,-23,24,-23v15,0,25,9,25,23v0,13,-11,23,-25,23xm100,-30v-14,0,-23,-9,-24,-22v0,-14,10,-23,24,-23v15,0,25,9,25,23v0,13,-11,22,-25,22","w":199},"\u00f8":{"d":"203,-94v6,83,-80,122,-145,85r-12,15r-20,-16r13,-16v-43,-59,-17,-168,72,-168v22,0,37,5,51,13r11,-14r19,16r-11,14v13,17,20,42,22,71xm77,-34v57,41,116,-33,81,-104xm144,-156v-57,-38,-116,33,-81,103","w":220,"k":{"f":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19}},"\u00f9":{"d":"98,5v-91,0,-61,-111,-66,-194r33,0v7,63,-25,164,42,166v31,0,47,-21,56,-43r0,-123r33,0r0,135v-1,19,2,38,4,54r-22,0r-9,-31r-3,0v-13,21,-34,36,-68,36xm127,-205r-20,0r-45,-46r0,-8r39,0","w":231},"\u00fa":{"d":"98,5v-91,0,-61,-111,-66,-194r33,0v7,63,-25,164,42,166v31,0,47,-21,56,-43r0,-123r33,0r0,135v-1,19,2,38,4,54r-22,0r-9,-31r-3,0v-13,21,-34,36,-68,36xm118,-259r37,0r0,8r-40,46r-20,0","w":231},"\u00fb":{"d":"111,-278r15,0v15,25,29,43,45,67r-29,0v-10,-15,-20,-31,-26,-50v-7,19,-17,35,-28,50r-28,0xm98,5v-91,0,-61,-111,-66,-194r33,0v7,63,-25,164,42,166v31,0,47,-21,56,-43r0,-123r33,0r0,135v-1,19,2,38,4,54r-22,0r-9,-31r-3,0v-13,21,-34,36,-68,36","w":231},"\u00fc":{"d":"98,5v-91,0,-61,-111,-66,-194r33,0v7,63,-25,164,42,166v31,0,47,-21,56,-43r0,-123r33,0r0,135v-1,19,2,38,4,54r-22,0r-9,-31r-3,0v-13,21,-34,36,-68,36xm72,-215v-11,0,-20,-8,-20,-20v0,-12,9,-20,20,-20v11,0,21,9,21,20v0,11,-10,20,-21,20xm150,-215v-11,0,-21,-9,-21,-20v0,-11,10,-20,21,-20v11,0,20,9,20,20v0,11,-9,20,-20,20","w":231},"\u00fd":{"d":"42,-189r60,156r4,0v12,-56,32,-104,48,-156r34,0r-76,205v-12,33,-35,69,-82,55r6,-29v31,8,46,-13,51,-41r-84,-190r39,0xm109,-259r37,0r0,8r-40,46r-20,0","w":191,"k":{" ":13,"\u00a0":13,",":26,".":26,"\u2026":26,"v":-3,"y":-3,"\u00fd":-3,"\u00ff":-3,"w":-2,"x":5,"z":4}},"\u00fe":{"d":"205,-99v0,80,-66,123,-140,95r0,76r-33,0r0,-324r33,0r0,84v17,-10,28,-27,58,-26v58,2,82,32,82,95xm170,-99v12,-75,-105,-93,-105,-22r0,85v45,31,114,2,105,-63","w":226,"k":{"f":4,"v":4,"y":4,"\u00fd":4,"\u00ff":4,"w":4,"x":9,"z":6,"\"":19,"'":19,"\u2018":19,"\u2019":19,"\u201c":19,"\u201d":19}},"\u00ff":{"d":"42,-189r60,156r4,0v12,-56,32,-104,48,-156r34,0r-76,205v-12,33,-35,69,-82,55r6,-29v31,8,46,-13,51,-41r-84,-190r39,0xm52,-215v-11,0,-20,-8,-20,-20v0,-12,9,-20,20,-20v11,0,21,9,21,20v0,11,-10,20,-21,20xm130,-215v-11,0,-21,-9,-21,-20v0,-11,10,-20,21,-20v11,0,20,9,20,20v0,11,-9,20,-20,20","w":191,"k":{" ":13,"\u00a0":13,",":26,".":26,"\u2026":26,"v":-3,"y":-3,"\u00fd":-3,"\u00ff":-3,"w":-2,"x":5,"z":4}},"\u2013":{"d":"46,-119r169,0r0,31r-169,0r0,-31","w":260,"k":{" ":29,"\u00a0":29,"*":3,"-":4,"\u00ad":4,"\u2013":4,"\u2014":4,",":45,".":45,"\u2026":45,"T":5,"V":2,"X":3,"Y":3,"\u00dd":3,"\u00c6":3,"\"":44,"'":44,"\u2018":44,"\u2019":44,"\u201c":44,"\u201d":44,")":2,"]":2,"}":2}},"\u2014":{"d":"46,-119r232,0r0,31r-232,0r0,-31","w":323,"k":{" ":29,"\u00a0":29,"*":3,"-":4,"\u00ad":4,"\u2013":4,"\u2014":4,",":45,".":45,"\u2026":45,"T":5,"V":2,"X":3,"Y":3,"\u00dd":3,"\u00c6":3,"\"":44,"'":44,"\u2018":44,"\u2019":44,"\u201c":44,"\u201d":44,")":2,"]":2,"}":2}},"\u2018":{"d":"41,-204v-45,0,-20,-75,10,-78r10,15v-10,5,-20,12,-19,26v13,-4,21,7,21,18v0,13,-10,19,-22,19","w":78,"k":{" ":30,"\u00a0":30,"-":54,"\u00ad":54,"\u2013":54,"\u2014":54,",":44,".":44,"\u2026":44,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"c":36,"e":36,"g":36,"o":36,"q":36,"\u00e7":36,"\u00e8":36,"\u00e9":36,"\u00ea":36,"\u00eb":36,"\u00f0":36,"\u00f2":36,"\u00f3":36,"\u00f4":36,"\u00f5":36,"\u00f6":36,"\u00f8":36,"\u00c6":72,"A":44,"\u00c0":44,"\u00c1":44,"\u00c2":44,"\u00c3":44,"\u00c4":44,"\u00c5":44,"a":22,"m":22,"n":22,"p":22,"r":22,"s":22,"u":22,"\u00e6":22}},"\u2019":{"d":"37,-255v42,1,25,66,0,73v-11,10,-14,-2,-20,-10v10,-5,19,-11,19,-25v-12,3,-20,-7,-20,-19v0,-12,9,-19,21,-19","w":78,"k":{" ":30,"\u00a0":30,"-":54,"\u00ad":54,"\u2013":54,"\u2014":54,",":44,".":44,"\u2026":44,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"c":36,"e":36,"g":36,"o":36,"q":36,"\u00e7":36,"\u00e8":36,"\u00e9":36,"\u00ea":36,"\u00eb":36,"\u00f0":36,"\u00f2":36,"\u00f3":36,"\u00f4":36,"\u00f5":36,"\u00f6":36,"\u00f8":36,"\u00c6":72,"A":44,"\u00c0":44,"\u00c1":44,"\u00c2":44,"\u00c3":44,"\u00c4":44,"\u00c5":44,"a":22,"m":22,"n":22,"p":22,"r":22,"s":22,"u":22,"\u00e6":22}},"\u201c":{"d":"99,-204v-41,-1,-24,-66,0,-73v11,-10,14,2,20,10v-10,5,-20,12,-19,26v13,-4,21,7,21,18v0,13,-10,19,-22,19xm41,-204v-45,0,-20,-75,10,-78r10,15v-10,5,-20,12,-19,26v13,-4,21,7,21,18v0,13,-10,19,-22,19","w":136,"k":{" ":30,"\u00a0":30,"-":54,"\u00ad":54,"\u2013":54,"\u2014":54,",":44,".":44,"\u2026":44,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"c":36,"e":36,"g":36,"o":36,"q":36,"\u00e7":36,"\u00e8":36,"\u00e9":36,"\u00ea":36,"\u00eb":36,"\u00f0":36,"\u00f2":36,"\u00f3":36,"\u00f4":36,"\u00f5":36,"\u00f6":36,"\u00f8":36,"\u00c6":72,"A":44,"\u00c0":44,"\u00c1":44,"\u00c2":44,"\u00c3":44,"\u00c4":44,"\u00c5":44,"a":22,"m":22,"n":22,"p":22,"r":22,"s":22,"u":22,"\u00e6":22}},"\u201d":{"d":"95,-255v42,0,25,66,1,74v-12,10,-15,-1,-21,-10v10,-5,20,-12,20,-26v-12,3,-21,-7,-21,-18v0,-12,10,-19,21,-20xm37,-255v48,7,19,75,-10,79r-10,-15v10,-5,20,-12,19,-26v-11,3,-20,-7,-20,-18v0,-12,10,-19,21,-20","w":136,"k":{" ":30,"\u00a0":30,"-":54,"\u00ad":54,"\u2013":54,"\u2014":54,",":44,".":44,"\u2026":44,"C":14,"G":14,"O":14,"Q":14,"\u00c7":14,"\u00d2":14,"\u00d3":14,"\u00d4":14,"\u00d5":14,"\u00d6":14,"\u00d8":14,"V":-14,"W":-14,"Y":-13,"\u00dd":-13,"c":36,"e":36,"g":36,"o":36,"q":36,"\u00e7":36,"\u00e8":36,"\u00e9":36,"\u00ea":36,"\u00eb":36,"\u00f0":36,"\u00f2":36,"\u00f3":36,"\u00f4":36,"\u00f5":36,"\u00f6":36,"\u00f8":36,"\u00c6":72,"A":44,"\u00c0":44,"\u00c1":44,"\u00c2":44,"\u00c3":44,"\u00c4":44,"\u00c5":44,"a":22,"m":22,"n":22,"p":22,"r":22,"s":22,"u":22,"\u00e6":22}},"\u2026":{"d":"247,4v-14,0,-25,-9,-25,-22v0,-14,10,-23,25,-23v14,0,24,9,24,23v-1,12,-10,22,-24,22xm148,4v-14,0,-23,-9,-24,-22v0,-14,10,-23,24,-23v15,0,24,8,24,23v0,13,-10,22,-24,22xm50,4v-14,0,-23,-9,-24,-22v0,-14,10,-23,24,-23v15,0,24,8,24,23v0,13,-10,22,-24,22","w":295,"k":{" ":11,"\u00a0":11,"*":9,"-":45,"\u00ad":45,"\u2013":45,"\u2014":45,"T":4,"V":4,"W":3,"Y":5,"\u00dd":5,"\"":50,"'":50,"\u2018":50,"\u2019":50,"\u201c":50,"\u201d":50,"\u00ae":6,"\u2122":6}},"\u2122":{"d":"153,-223r-53,0r0,101r-34,0r0,-101r-52,0r0,-29r139,0r0,29xm307,-218v-12,30,-31,54,-49,79r-15,0v-19,-24,-34,-52,-50,-79v6,28,7,61,6,96r-31,0r0,-130r34,0v17,27,37,51,51,81v15,-29,33,-54,50,-81r34,0r0,130r-32,0v-2,-33,3,-72,2,-96","w":351}}});
